Attribute VB_Name = "SPA_Admin_Lib"
Option Explicit

'what is new
'2.6.9 : toolbar definitions for new tabs (JN)

Public Const COLOR_WHITE As Long = &HFFFFFF

'Public Const C_ABPE_SPA_TOKEN As String = "ABPE_SPA_TOKEN"

'Public Const TLB_SPA_MKT_USER As String = "140"
Public Const TLB_SPA_MKT_USER_ID As Long = 2725
'Public Const TLB_SPA_MKT_USER_MTNC As String = "0"
Public Const TLB_SPA_MKT_USER_MTNC_ID As Long = 2729
'Public Const TLB_SPA_MKT_USER_MTNC_REPLACE As String = "0"
Public Const TLB_SPA_MKT_USER_MTNC_REPLACE_ID As Long = 2730
'Public Const TLB_SPA_PG As String = "141"
Public Const TLB_SPA_PG_ID As Long = 2726
'Public Const TLB_SPA_PG_MTNC As String = "0"
Public Const TLB_SPA_PG_MTNC_ID As Long = 2732
'Public Const TLB_SPA_MKT As String = "142"
Public Const TLB_SPA_MKT_ID As Long = 2727
'Public Const TLB_SPA_MKT_MTNC As String = "148"
Public Const TLB_SPA_MKT_MTNC_ID As Long = 2731

Public Const TLB_SPA_PG_MKT_MTNC_ID As Long = 2733
Public Const TLB_SPA_PG_MKT_MTNC_PROD_ID As Long = 2734
Public Const TLB_SPA_PG_MKT_MTNC_AUTH_ID As Long = 2735
'Public Const TLB_SPA_PG_MKT As String = "143"
Public Const TLB_SPA_PG_MKT_ID As Long = 2728
Public Const TLB_SPA_PG_MKT_ID2 As Long = 2932
Public Const TLB_SPA_PG_MKT_ID3 As Long = 2933
'Public Const TLB_SPA_PG_MKT_BI As String = "151"
Public Const TLB_SPA_PG_MKT_BI_ID As Long = 2736

' SPA_Admin_PG
Public Const REQ_SELECT_SPA_PG As String = "exec SPA_ProductGroup_sel $SPG_Code$"
Public Const REQ_INSERT_SPA_PG As String = "exec SPA_ProductGroup_ins $SPG_Code$,$SPG_Desc$,$SPG_SDesc$,$Z_Creator$"
Public Const REQ_UPDATE_SPA_PG As String = "exec SPA_ProductGroup_upd $SPG_Code$,$SPG_Desc$,$SPG_SDesc$,$Z_Last_Upd_User$,$iConcurrency$"
Public Const REQ_DELETE_SPA_PG As String = "exec SPA_ProductGroup_del $SPG_Code$,$Z_Last_Upd_User$,$iConcurrency$"

Public Const REQ_DELETE_SPA_PG_AUTH_LEVEL   As String = "exec SPA_AuthLevel_del $SPG_Code$,$SPM_Code$"
Public Const REQ_DELETE_SPA_PG_PGAMBI_LINK  As String = "exec SPA_PGAMBI_Link_del $SPG_Code$"
Public Const REQ_DELETE_SPA_PG_PGAM_LINK    As String = "exec SPA_ProdGroupAuthMarket_Link_del2 $SPG_Code$,$SPM_Code$,$VNewDate_End$,$Z_Last_Upd_User$"

Public Const REQ_PRODUCT_GROUP_IS_USED      As String = "exec SPA_ProductGroup_IsUsed $SPG_Code$"

' SPA_Admin_MKT
Public Const REQ_SELECT_SPA_MKT As String = "exec SPA_AuthMarket_sel $SPM_Code$"
Public Const REQ_INSERT_SPA_MKT As String = "exec SPA_AuthMarket_ins $SPM_Code$,$SPM_Desc$,$FullAuth_Flag$,$SPM_SDesc$,$ObvioustAuth_Flag$,$Z_Creator$"
Public Const REQ_UPDATE_SPA_MKT As String = "exec SPA_AuthMarket_upd $SPM_Code$,$SPM_Desc$,$FullAuth_Flag$,$SPM_SDesc$,$ObvioustAuth_Flag$,$Z_Last_Upd_User$,$iConcurrency$"
Public Const REQ_DELETE_SPA_MKT As String = "exec SPA_AuthMarket_del $SPM_Code$,$Z_Last_Upd_User$,$iConcurrency$"

Public Const REQ_INSERT_SPA_AUTH_COUNTRIES As String = "exec SPA_AuthCountries_ins $SPM_Code$,$CT_Code$,$SPACT_Id$,$VNewDate_Start$,$VNewDate_End$,$U_Code$"
Public Const REQ_DELETE_SPA_AUTH_Countries As String = "exec SPA_AuthCountries_del $SPM_Code$,$CT_Code$,$VNewDate_End$,$U_Code$, '$drop_flag$'"

Public Const REQ_DELETE_SPA_UNUSED_AUTH_COUNTRIES As String = "exec SPA_AuthCountries_Del3 $SPACT_ID$"



Public Const REQ_COUNTRY_IS_USED As String = "exec SPA_AuthCountries_IsUsed $CT_Code$"
Public Const REQ_MARKET_IS_USED As String = "exec SPA_AuthMarket_IsUsed $SPM_Code$"

' SPA_Admin_PG_MKT
Public Const REQ_SELECT_SPA_PG_MKT As String = "EXEC SPA_ProdGroupAuthMarket_Link_sel $SPGAM_Id$"
Public Const REQ_INSERT_SPA_PG_MKT As String = "EXEC SPA_ProdGroupAuthMarket_Link_ins $SPGAM_Id$, $SPG_Code$, $SPM_Code$, $SPG_Default$, $VDate_Start$, $VDate_End$, $U_Code$"
Public Const REQ_DELETE_SPA_PG_MKT As String = "exec SPA_ProdGroupAuthMarket_Link_del $SPGAM_Id$, $VDate_End$, $U_Code$, $iConcurrency$"
Public Const REQ_DELETE_DB1_SPA_PG_MKT As String = "exec SPA_ProdGroupAuthMarket_Link_db1_del $SPGAM_Id$, $iConcurrency$"
Public Const REQ_DELETE_DB2_SPA_PG_MKT As String = "exec SPA_ProdGroupAuthMarket_Link_db2_del $SPGAM_Id$"
Public Const REQ_DELETE_DB3_SPA_PG_MKT As String = "exec SPA_ProdGroupAuthMarket_Link_db3_del $SPGAM_Id$"

Public Const REQ_PG_MKT_BI_INS As String = "EXEC SPA_PGAMBI_Link_ins $SPGAM_Id$, $BI_SAP_Code$"
Public Const REQ_PG_MKT_LEVEL_INS As String = "EXEC SPA_AuthLevel_ins $SPGAM_Id$, $SPR_Code$, $DiscountPercent$"

Public Const REQ_PG_MKT_BI_LINKED_LIST As String = "EXEC SPA_PGAMBI_Link_lst $SPGAM_Id$"

Public Const REQ_AUTH_MARKET_CBO As String = "exec SPA_MKT_cbo"
Public Const REQ_PROD_GROUP_CBO As String = "exec SPA_PG_cbo"
Public Const REQ_AUTH_ROLE_CBO As String = "EXEC SPA_AuthRoles_cbo"

Public Const REQ_AUTH_LEVEL_LIST As String = "EXEC SPA_AuthLevel_lst $SPGAM_Id$"

Public Const REQ_SPA_PG_MKT_IS_USED As String = "exec SPA_PGAMBI_Link_IsUsed $SPGAM_Id$, $TESTDATE$"

' SPA_Admin_MKT_USER
Public Const REQ_SELECT_SPA_MKT_USER As String = "exec SPA_MKT_USER_sel $SPA_U_Code$"

Public Const REQ_INSERT_SPA_MKT_USER_LINK As String = "exec SPA_AuthMarketUser_Link_ins $USER_Code$,$SPM_Code$,$SPA_UserType_Code$,$SPAMU_Id$,$VNewDate_Start$,$VNewDate_End$,$U_Code$"
Public Const REQ_UPDATE_SPA_MKT_USER As String = ""
Public Const REQ_CLOSE_SPA_MKT_USER_LINK As String = "exec SPA_AuthMarketUser_Link_del $USER_Code$,$SPM_Code$,$SPA_UserType_Code$,$VNewDate_End$,$U_Code$"
Public Const REQ_DELETE_SPA_MKT_USER_LINK As String = "exec SPA_AuthMarketUser_Link_del3 $USER_Code$,$SPM_Code$,$SPA_UserType_Code$,$VNewDate_Start$"
Public Const REQ_UPDATE_SPA_MKT_USER_LINK As String = "exec SPA_AuthMarketUser_Link_upd $USER_Code$,$SPM_Code$,$SPA_UserType_Code$,$U_Code$"
Public Const REQ_DELETE_ALL_SPA_MKT_USER_LINK As String = "exec SPA_AuthMarketUser_Link_del2 $USER_Code$,$SPM_Code$,$VNewDate_End$,$U_Code$"


Public Const REQ_INSERT_SPA_USER_ROLE As String = "exec SPA_UserRoles_ins $SPR_Code2$,$USER_Code$,$Next_U_Code2$,$SPA_no_conf_email$,$SPU_Id$,$VNewDate_Start$,$VNewDate_End$,$U_Code$"
'Public Const REQ_UPDATE_SPA_USER_ROLE As String = "exec SPA_UserRoles_upd $SPU_Id$,$iConcurrency$,$U_Code$"
'Public Const REQ_UPDATE_SPA_USER_ROLE_2 As String = "exec SPA_UserRoles_upd2 $SPR_Code$,$USER_Code$,$Next_U_Code$,$VDate_Start$,$U_Code$"
Public Const REQ_CLOSE_SPA_USER_ROLE As String = "exec SPA_UserRoles_del $SPU_Id$,$VNewDate_End$,$iConcurrency$,$U_Code$"
Public Const REQ_DELETE_SPA_USER_ROLE As String = "exec SPA_UserRoles_del2 $USER_Code$,$VNewDate_Start$"

Public Const REQ_USERROLE_IS_USED As String = "exec SPA_UserRoles_IsUsed $USER_Code$"
Public Const REQ_USERROLE_EXISTS  As String = "exec SPA_UserRoles_Exists $USER_Code$"
Public Const REQ_USER_HAS_OPEN_SPA As String = "exec SPA_UserRoles_HasSPAOpen $USER_Code$"

Public Const REQ_REPLACEMENT_GRID As String = "exec SPA_UserReplacement_Lst $SPA_U_Code$"
Public Const REQ_USERMARKET_GRID As String = "exec SPA_AuthMarketUser_Link_lst4 $USER_Code$,$Language_Code$"
Public Const REQ_SPA_PENDING_REQUERSTS_GRID As String = "exec SPA_Pending_Requests_lst $Auth_U_Code$,$Language_Code$"

Public Const REQ_REPLACER_CBO As String = "exec SPA_MKT_USER_cbo2 $USER_Code$"

Public Const REQ_ROLES_CBO As String = "exec SPA_UserRoles_cbo"
Public Const REQ_NEXT_USER_CBO As String = "exec SPA_UserRoles_cbo2 $USER_Code$"
'Public Const REQ_USER_TYPE_CBO As String = "exec SPA_AuthMarketUserType_cbo"
Public Const REQ_COVERING_USER_CBO As String = "exec SPA_MKT_USER_cbo $USER_Code$"

Public Const REQ_REPLACEMENT_INS As String = "exec SPA_UserReplacement_ins $SPUR_Id$, $USER_Code$, $Date_Start$, $Date_End$, $Covering_U_Code$, $Replacement_Comment$, $Z_Creator$"
Public Const REQ_REPLACEMENT_UPD As String = "exec SPA_UserReplacement_upd $SPUR_Id$, $USER_Code$, $Date_Start$, $Date_End$, $Covering_U_Code$, $Replacement_Comment$, $subiConcurrency$, $Z_Creator$"
Public Const REQ_REPLACEMENT_DEL As String = "exec SPA_UserReplacement_del $SPUR_Id$, $subiConcurrency$, $Z_Creator$"

' SPA_Admin_Navig
Public Const REQ_FILTER_MKT_CBO As String = "exec SPA_MKT_cbo"
Public Const REQ_FILTER_PG_CBO As String = "exec SPA_PG_cbo"















' deletes SPA_ProdGroupAuthMarket_Link RECORD AND RETURN date of rule is applied
' as_VDateStart is string in Format( Date, "dd\/mm\/yyyy" )
Public Function SPA_Admin_PG_MKT_Delete(ByRef ao_Armdb As Object, ByVal al_SPGAM_Id As Long, ByVal as_VDateStart As String, ByVal ad_changeRequested As Date, ByVal al_Ucode As Long) As Date
On Error GoTo errHandler

    Dim ld_changePossible As Date
    Dim lb_removeOld As Boolean
    lb_removeOld = False
    
    ld_changePossible = SPA_Validity_GetPossibleChange(ao_Armdb, al_SPGAM_Id, as_VDateStart, ad_changeRequested, lb_removeOld)

    Call SPA_Admin_PG_MKT_DeleteDB(ao_Armdb, al_SPGAM_Id, lb_removeOld, ld_changePossible, al_Ucode)

    SPA_Admin_PG_MKT_Delete = ld_changePossible
    Exit Function
errHandler:
    Call Err.Raise(Err.Number, "SPA_Admin_Lib.SPA_Admin_PG_MKT_Delete" & "" & Err.Source, Err.Description)
End Function

Private Sub SPA_Admin_PG_MKT_DeleteDB(ByRef ao_Armdb As Object, ByVal as_oldCode As String, ByVal lb_removeOld As Boolean, ByVal ld_changePossible As Date, ByVal al_Ucode As Long)
On Error GoTo errHandler
    Dim ls_Req As String
    
    If lb_removeOld Then
        ' physically remove record from db
        ' 1. items
        ls_Req = Replace(REQ_DELETE_DB3_SPA_PG_MKT, "$SPGAM_Id$", as_oldCode, , , vbTextCompare)
        If Not ao_Armdb.ExecuteSQL(ls_Req) Then
            Call Err.Raise(vbObjectError + 6, "ao_armDB.ExecuteSQL - " & "SQL : " & ls_Req, "SQL Error: " & ao_Armdb.LastErrorMessage)
        End If
        
        ' 2. AuthLevel
        ls_Req = Replace(REQ_DELETE_DB2_SPA_PG_MKT, "$SPGAM_Id$", as_oldCode, , , vbTextCompare)
        If Not ao_Armdb.ExecuteSQL(ls_Req) Then
            Call Err.Raise(vbObjectError + 6, "ao_armDB.ExecuteSQL - " & "SQL : " & ls_Req, "SQL Error: " & ao_Armdb.LastErrorMessage)
        End If

        ' 3. Master record
        ls_Req = Replace(REQ_DELETE_DB1_SPA_PG_MKT, "$SPGAM_Id$", as_oldCode, , , vbTextCompare)
        ls_Req = Replace(ls_Req, "$iConcurrency$", "NULL", , , vbTextCompare)
        If Not ao_Armdb.ExecuteSQL(ls_Req) Then
            Call Err.Raise(vbObjectError + 6, "ao_armDB.ExecuteSQL - " & "SQL : " & ls_Req, "SQL Error: " & ao_Armdb.LastErrorMessage)
        End If
        If ao_Armdb.SQLRowsAffected <> 1 Then
            Call Err.Raise(vbObjectError + 9, "SQL : " & ls_Req, "1<>" & ao_Armdb.SQLRowsAffected)      'SQLBadRowAffectedCount = vbObjectError + 9  ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
        End If
    Else
        ' common placeholders
        ls_Req = Replace(REQ_DELETE_SPA_PG_MKT, "$SPGAM_Id$", as_oldCode, , , vbTextCompare)
        ls_Req = Replace(ls_Req, "$iConcurrency$", "NULL", , , vbTextCompare)
        ls_Req = Replace(ls_Req, "$U_Code$", al_Ucode, , , vbTextCompare)
        ls_Req = Replace(ls_Req, "$VDate_End$", "'" & Format(ld_changePossible - 1, "yyyy-mm-dd") & "'", , , vbTextCompare)
        If Not ao_Armdb.ExecuteSQL(ls_Req) Then
            Call Err.Raise(vbObjectError + 6, "ao_armDB.ExecuteSQL - " & "SQL : " & ls_Req, "SQL Error: " & ao_Armdb.LastErrorMessage)
        End If
        If ao_Armdb.SQLRowsAffected <> 1 Then
            Call Err.Raise(vbObjectError + 9, "SQL : " & ls_Req, "1<>" & ao_Armdb.SQLRowsAffected)      'SQLBadRowAffectedCount = vbObjectError + 9  ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
        End If
    
    End If
    
    Exit Sub
errHandler:
    Call Err.Raise(Err.Number, "SPA_Admin_Lib.SPA_Admin_PG_MKT_Delete" & "" & Err.Source, Err.Description)
End Sub

Private Function SPA_Validity_GetPossibleChange(ByRef lo_ArmDb As Object, ByVal al_oldKey As Long, ByVal as_VDateStart As String, ByVal ad_changeRequested As Date, ByRef ab_retRemovePossible As Boolean) As Date
On Error GoTo errHandler
    ' CHECK IF SPGAM_ID ise used today in some SPA_Item records for SPA_Header
    ab_retRemovePossible = False
    Debug.Assert (IsDate(as_VDateStart))
    
    Dim ls_startFormated As String, ls_requestedFormated As String
    ls_startFormated = Format(CDate(as_VDateStart), "yyyymmdd")
    ls_requestedFormated = Format(ad_changeRequested, "yyyymmdd")
    
    If ls_startFormated < ls_requestedFormated Then
        If SPA_EntryIsUsed(lo_ArmDb, al_oldKey, ad_changeRequested) Then
            ad_changeRequested = ad_changeRequested + 1
        End If
    ElseIf ls_startFormated = ls_requestedFormated Then
        If SPA_EntryIsUsed(lo_ArmDb, al_oldKey, ad_changeRequested) Then
            ad_changeRequested = ad_changeRequested + 1
        Else
            ' we can remove fom DB, because in this case rule was newer used
            ab_retRemovePossible = True
        End If
    Else    ' startDate>ad_changeRequested
        ' also in this case we can remove fom DB, because in this case rule was newer used
        ab_retRemovePossible = True
        ' and change possible can only be from start date of validity of the record
        ad_changeRequested = CDate(as_VDateStart)
    End If
        
    SPA_Validity_GetPossibleChange = ad_changeRequested
    Exit Function
errHandler:
    Call Err.Raise(Err.Number, "SPA_Admin_Lib.SPA_Validity_GetPossibleChange" & "" & Err.Source, Err.Description)
End Function

Private Function SPA_EntryIsUsed(ByRef ao_Armdb As Object, ByVal al_SPGAM_Id As Long, ByVal ad_atDate As Date) As Boolean
On Error GoTo errHandler
    
Dim ls_Req As String
Dim ll_cursor As Long
    
    SPA_EntryIsUsed = False
    
    ls_Req = Replace(REQ_SPA_PG_MKT_IS_USED, "$SPGAM_Id$", al_SPGAM_Id, , , vbTextCompare)
    ls_Req = Replace(ls_Req, "$TESTDATE$", "'" & Format(ad_atDate, "yyyy-mm-dd") & "'", , , vbTextCompare)
    ll_cursor = ao_Armdb.OpenSQL(ls_Req)
    If ll_cursor = 0 Then
        Call Err.Raise(vbObjectError + 6, "ao_armDB.OpenSQL - " & "SQL : " & ls_Req, "SQL Error: " & ao_Armdb.LastErrorMessage)
    End If
    
    If ao_Armdb.RowCount(ll_cursor) > 0 Then
        SPA_EntryIsUsed = True
    End If
    
    Call ao_Armdb.Close(ll_cursor)
    ll_cursor = 0
    
    Exit Function
errHandler:
    If ll_cursor > 0 Then
        Call ao_Armdb.Close(ll_cursor)
    End If
    Call Err.Raise(Err.Number, "SPA_Admin_Lib.SPA_EntryIsUsed" & "" & Err.Source, Err.Description)
End Function

